unit ujsAVI;
{                                                                             |
    Selective extraction of frames from an AVI file to a series of CPA files  |
                                                                              |
    Author: Jean SUZINEAU <Jean.Suzineau@wanadoo.fr> http://www.mars42.com    |
                                                                              |
    Copyright (C) 1999  Jean SUZINEAU - MARS42                                |
                                                                              |
    This library is free software; you can redistribute it and/or             |
    modify it under the terms of the GNU Lesser General Public                |
    License as published by the Free Software Foundation; either              |
    version 2 of the License, or (at your option) any later version.          |
                                                                              |
    This library is distributed in the hope that it will be useful,           |
    but WITHOUT ANY WARRANTY; without even the implied warranty of            |
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         |
    Lesser General Public License for more details.                           |
                                                                              |
    You should have received a copy of the GNU Lesser General Public          |
    License along with this library; if not, write to the Free Software       |
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA |
|                                                                             }

{                                                                             |
CHANGES:                                                                      |
   0.3 : First distributed version.                                           |
   0.2 : First version completely in Pascal                                   |
   0.1 : First version, project in CPP Builder with uCPA in Object Pascal and |
         everything else in CPP.                                              |
|                                                                             }
interface

uses
    Windows, SysUtils, Forms,
    uAVIFile, uDrawDib, uCPA, uStrings;
const
     MajorVersion= 0; // still alpha version
     MinorVersion= 3;

procedure ProcessAVIFile( FileName: String);

function CopyrightNotice: String;

implementation

procedure ErrMsg(Msg, _In: String);
begin
     Msg:= Format( Msg, [_In]);
     Application.MessageBox( PChar(Msg), s_Error_Title, MB_OK or MB_ICONEXCLAMATION);
end;

const
     MAXSTREAMS= 100;
var
   StreamsCount: integer;  // count of streams in AVI file
   Streams: array[0..MAXSTREAMS-1] of PAVISTREAM;

// ProcessStreams - opens the streams in an AVI file and
//                  process frames of video streams
// Global variables
// StreamsCount - count of the number of streams in AVI file
// Streams[] = array of stream-interface pointers
procedure ProcessStreams( Save: BOOL; FileName: String);
var
   avis: TAVISTREAMINFO;
   i: integer;
   pgf: PGETFRAME;
   lpos: Longint;
   lpbmih: PBITMAPINFOHEADER;
   lpbi: PBITMAPINFO;
   lpbiSize: Longint;
   //hdd: HDRAWDIB;
   nHeaderSize: DWORD;
begin
     //hdd:= DrawDibOpen;
     LastImage:= -1;

     for i:= 0 to StreamsCount
     do
       begin
       AVIStreamInfo( Streams[i], @avis, sizeof(avis));
       if avis.fccType = streamtypeVIDEO
       then
           begin
           AVIStreamReadFormat( Streams[i],0, nil, lpbiSize);
           GetMem( lpbi, lpbiSize);
           AVIStreamReadFormat( Streams[i],0, lpbi, lpbiSize);
           pgf:= AVIStreamGetFrameOpen( Streams[i], nil);
           lpos:=0;
           lpbmih:= PBITMAPINFOHEADER(AVIStreamGetFrame( pgf, lpos));
           // code for displaying first frame in a TForm
           // DrawDibDraw( hdd, TheForm.Canvas.Handle, 0,0,
           //             TheForm.ClientWidth, TheForm.ClientHeight,
           //             lpbmih, nil, 0,0, -1,-1, 0);

           while lpbmih <> nil
           do
             begin
             nHeaderSize:= DWORD(lpbmih^.biSize);

             Make_CPA( lpos,lpbmih,nHeaderSize,Save);

             Inc( lpos);
             lpbmih:= PBITMAPINFOHEADER(AVIStreamGetFrame( pgf, lpos));
             end;
           AVIStreamGetFrameClose( pgf);
           FreeMem( lpbi, lpbiSize);
           end;
       end;

     GetMinMax;

     //DrawDibClose( hdd);
end;

// ProcessAVIFile - loads AVIFile, opens an AVI file and splits it in CPA files
// Global variables
// StreamsCount - count of the number of streams in AVI file
// Streams[] = array of stream-interface pointers
procedure ProcessAVIFile( FileName: String);
var
   hr: HResult;
   pfile: PAVIFILE; // file-interface pointer from AVIFileOpen
   i: Integer;
   FileExt: String;
   FileExtPos: Integer;
begin
     // Compute generic CPA file name
     GenericCPAFileName:= FileName;
     FileExt:= ExtractFileExt( FileName);
     if FileExt <> ''
     then
         begin
         FileExtPos:= Pos( FileExt, GenericCPAFileName);
         if FileExtPos > 0
         then
             Delete( GenericCPAFileName, FileExtPos, 4);
         end;
     GenericCPAFileName:= GenericCPAFileName+'_';

    AVIFileInit;          // opens AVIFile library

    hr:= AVIFileOpen(@pfile, PChar(FileName), OF_SHARE_DENY_WRITE, nil);
    if hr <> 0
    then
        ErrMsg(s_Unable_to_open, FileName)
    else
        begin
        // Open the streams until a stream is not available.
        for i:= 0 to MAXSTREAMS-1
        do
          begin
          Streams[i]:= nil;
          if AVIFileGetStream(pfile, @Streams[i], 0, i) <> AVIERR_OK then break;
          if Streams[i] = nil                                        then break;
          end;

        // Display error message-stream not found.
        if i = 0
        then
            begin
            StreamsCount:= 0;
            ErrMsg(s_Unable_to_open, FileName);
            end
        else
            begin
            StreamsCount:= i - 1;

            if Select_brightest_images
            then
                begin
                // First pass to get Min and Max info from each frame
                ProcessStreams( FALSE, FileName);

                // Second pass to convert brightest frames
                ProcessStreams( TRUE , FileName);
                end
            else
                ProcessStreams( TRUE , FileName);
            end;
        AVIFileRelease(pfile);  // closes the file
        end;
    AVIFileExit;                                 // releases AVIFile library
end;

function CopyrightNotice: String;
begin
     Result:= Format( s_CopyrightNoticeMask, [MajorVersion, MinorVersion]);
end;

end.
