unit uCPA_Header;
{                                                                             |
    Part of library ujsAVI                                                    |
                                                                              |
    CPA file header type based on description of CPA PisesAtlas-Prism97       |
    file format by Cyril CAVADORE. See http://www.astrosurf.com/saturne/pap   |
    "signature" field type modified from Longint to Cardinal to avoid Delphi  |
    warning                                                                   |
                                                                              |
    Author: Jean SUZINEAU <Jean.Suzineau@wanadoo.fr> http://www.mars42.com    |
                                                                              |
    Copyright (C) 1999  Jean SUZINEAU - MARS42                                |
                                                                              |
    See ujsAVI.pas for full copyright notice.                                 |
|                                                                             }
interface

type
    TEnteteCPA_Ver2
    =
     packed record // "packet" pour viter les trous de l'alignement 32 bits des datas
     Signature : Cardinal ; // Signature du format, ici egal : $F5C7D1FA
     Largeur   : Word ; // Largeur de l'image en pixels
     Longueur  : Word ; // Hauteur de l'image en pixels
     BinningX  : Word ; // Binning de l'image en X
     BinningY  : Word ; // Binning de l'image en Y
     SeuilHaut : array[1..3] of Double ; // Seuil haut de l'image, 3 pour les trichromies, 1 normalement !
     SeuilBas  : array[1..3] of Double ; // Seuil bas de l'image, 3 pour les trichromies, 1 normalement !
     TypeData  : Byte ; // Type de donnes.
     NbrePlan  : Byte; // Nombre de plans images 3 pour les trichromies, 1: normal.
     TimeDate  : TdateTime ; // codage en nombre de jours avec origine 0 pour 30/12/1899 12:00 am (cf. Delphi)
     TempsDePose : Double ; // en Ms
     MiroirX   : Boolean ; // miroir en X sur l'image
     MiroirY   : Boolean ; // miroir en Y sur l'image
     Telescope    : string[80] ; // infos sur le telescope
     Observateur  : string[80] ; // infos sur l'observateur
     Camera       : string[80] ; // Infos sur le type de camera
     Filtre       : string[80] ; // Infos sur les filtres utiliss
     Observatoire : string[80] ; // infos relatives sur l'endroit de la prise de vue.
     Focale : Double ; // focale de l'instrument ayant fait l'acquisition en mm
     Alpha  : Double ; // coordonnees alpha en radians du centre de l'image
     Delta  : Double ; // coordonnees delta en radians du centre de l'image
     PixX   : Double ; // Taille du pixel en microns sur X
     PixY   : Double ; // Taille du pixel en microns sur Y
     DebX,DebY, FinX,FinY : Integer ; // Coordonnes de fentre de l'image lors de l'acquisition X1,Y1,X2,Y2
     TypeCompression: Byte ; // 1: compression 0: pas de compression
     NombreBitsComp : Byte ; // Nombre de bits de compression fixe  8 pour typedata=3; 0 pour le reste.
     Commentaires   : array [1..4] of String[ 80] ; // Commentaires divers
     end;


implementation

end.
