unit uCPA;
{                                                                             |
    Part of library ujsAVI                                                    |
                                                                              |
    Routine to select and save a bitmap to a CPA file                         |
    Code based on description of CPA PisesAtlas-Prism97 file format           |
    by Cyril CAVADORE. See http://www.astrosurf.com/saturne/pap               |
                                                                              |
    Author: Jean SUZINEAU <Jean.Suzineau@wanadoo.fr> http://www.mars42.com    |
                                                                              |
    Copyright (C) 1999  Jean SUZINEAU - MARS42                                |
                                                                              |
    See ujsAVI.pas for full copyright notice.                                 |
|                                                                             }
interface

uses
    Windows, SysUtils,
    uCPA_Header,
    uStrings, uStrings_Files;

type
    TImagesStatisticsElement
    =
     record
     Min, Max: SmallInt;
     end;

var
   ImagesStatistics: array[0..600] of TImagesStatisticsElement;
   LastImage: Integer;
   TheMin, TheMax: Longint;
   DefaultHeader: TEnteteCPA_Ver2;

   Select_brightest_images,
   Stretch_levels,
   Crop: Boolean;
   Crop_Width: Integer = 400;
   GenericCPAFileName: String;


procedure Make_CPA( Index: LongInt; lpbmih: pbItmapInfoHeader;
                    ImageOffset: Longint; Save: Boolean);


procedure GetMinMax;

implementation

type
    TByteArray= array[0..999999999] of Byte;
    PByteArray= ^TByteArray        ;
    PWord     = ^Word              ;
    PSmallInt = ^SmallInt          ;

type
    TGrayFunction= function (P:Pointer):Byte;

function Gray_From_BMP16( P: Pointer): Byte;
var
   W: Word;
   R, G, B: Byte;
begin
     W:= PWord(P)^;
     B:= W and $1F;
     W:= W shr 5;
     G:= W and $1F;
     W:= W shr 5;
     R:= W and $1F;
     if (R <> G) or (R<>B)
     then
         begin
         Result:= Trunc((R+G+B)/3);
{
         S:= Format( s_Format_RGB, [R,G,B]);
         MessageBox( 0, PChar(S), s_This_is_not_a_gray_color, MB_OK);
}
         end
     else
         Result:= R;
end;

function Gray_From_BMP24( P: Pointer): Byte;
var
   R, G, B: Byte;
//   S: String;
begin
     R:= PByteArray(P)^[2];
     G:= PByteArray(P)^[1];
     B:= PByteArray(P)^[0];
     if (R <> G) or (R<>B)
     then
         begin
         Result:= R;
{
         S:= Format( s_Format_RGB, [R,G,B]);
         MessageBox( 0, PChar(S), s_This_is_not_a_gray_color, MB_OK);
}
         end
     else
         Result:= R;
end;

var
   CPANumber: Integer;
   Log: Text;

procedure Make_CPA( Index: LongInt; lpbmih: pbItmapInfoHeader;
                    ImageOffset: Longint; Save: Boolean);
const
     CPAPixelSize= 2;//bytes
var
   ecv2: TEnteteCPA_Ver2;
   BMPPixelSize: Word;
   Width, CPAByteWidth, Height: Word;
   pbB, pbI: PByteArray;
   psi: PSmallInt;
   Min, Max, Fish: SmallInt;
   I, J: Longint;
   F: File;
   _16bits: Boolean;
   pImage: PSmallInt;
   ImageSize: LongInt;
   GrayFromBMP: TGrayFunction;
   OffSet, Coef: double;
   procedure Stretch;
   var
      I, J: Longint;
   begin
        // Stretch levels to 0..255
        Coef:= 255 / (Max - Min);
        Offset:= Min;
        pbI:= PByteArray( pImage);

        for J:= 0 to Height -1
        do
          for I:= 0 to Width - 1
          do
            begin
            psi:= PSmallInt( pbI);
            psi^:= Trunc( (psi^ - Min) * Coef);
            pbI:= PByteArray( @(pbI^[CPAPixelSize]));
            end;
        Min:= 0;
        Max:= 255;
   end;

   procedure Crop_Image;
   var
      Half_Crop_Width,
      J: Integer;
      Bary_X, Bary_Y: double;
      Left, Top, Right, Bottom, DeltaX, CPAByteDeltaX: Integer;
      XD, YD: Integer;
      pbID: PByteArray;
      pImageD: PSmallInt;
      CroppedImageSize: LongInt;
      CPAByteCroppedWidth: Longint;
      procedure Barycenter;
      var
         I, J: Integer;
         si: SmallInt;
         CoeffSum: Double;
      begin
           Bary_X:= 0;
           Bary_Y:= 0;
           CoeffSum:= 0;
           pbI:= PByteArray( pImage);
           for J:= 0 to Height -1
           do
             for I:= 0 to Width - 1
             do
               begin
               si:= PSmallInt( pbI)^;
               Bary_X:= Bary_X+ (si*I);
               Bary_Y:= Bary_Y+ (si*J);
               CoeffSum:= CoeffSum + si;
               pbI:= PByteArray( @(pbI^[CPAPixelSize]));
               end;
           Bary_X:= Bary_X / CoeffSum;
           Bary_Y:= Bary_Y / CoeffSum;
      end;
   begin
        Half_Crop_Width:= Crop_Width div 2;
        Barycenter;
        Left:= Trunc( Bary_X)-Half_Crop_Width;
        Top:= Trunc( Bary_Y)-Half_Crop_Width;
        Right:= Left+Crop_Width-1;
        Bottom:= Top+Crop_Width-1;
        XD:= 0;
        YD:= 0;
        if Left < 0
        then
            begin
            XD:= 0-Left;
            Left:= 0;
            end;
        if Top < 0
        then
            begin
            YD:= 0-Top;
            Top:= 0;
            end;
        if Right > Width-1 then Right:= Width-1;
        if Bottom > Height-1 then Bottom:= Height-1;
        DeltaX:= Right - Left;
        CPAByteDeltaX:= DeltaX*CPAPixelSize;

        CPAByteCroppedWidth:= Crop_Width * CPAPixelSize;
        CroppedImageSize:= Crop_Width * CPAByteCroppedWidth;
        GetMem( pImageD, CroppedImageSize);
        FillChar( pImageD^, CroppedImageSize, 0);

        pbI := PByteArray( @(PByteArray( pImage )[(Top*Width          +Left)* CPAPixelSize]));
        pbID:= PByteArray( @(PByteArray( pImageD)[(YD  *Crop_Width+XD  )* CPAPixelSize]));

        for J:= Top to Bottom
        do
          begin
          Move( pbI^, pbID^, CPAByteDeltaX);
          pbI := PByteArray( @(pbI [CPAByteWidth       ]));
          pbID:= PByteArray( @(pbID[CPAByteCroppedWidth]));
          end;

        FreeMem( pImage, ImageSize);

        pImage:= pImageD;
        ImageSize:= CroppedImageSize;

        Width:= Crop_Width;
        CPAByteWidth:= Width*CPAPixelSize;
        Height:= Crop_Width;
   end;

   procedure Save_CPA;
   var
      J: Longint;
      FileName: String;
   begin
        Inc( CPANumber);
        if CPANumber = 0
        then
            begin
            Assign( Log, GenericCPAFileName+ sf_Sources);
            ReWrite( Log);
            end;
        FileName:= Format( sf_Format_CPA, [GenericCPAFileName, CPANumber]);
        WriteLn( Log, Format( s_Source_CPA, [ CPANumber, Index]));
        // Write CPA file, without lines compression
        AssignFile( F, FileName);
        Rewrite( F, 1);

        // Header initialization
        ecv2:= DefaultHeader;

        ecv2.Signature:= $F5C7D1FA;
        ecv2.Largeur:= Width;
        ecv2.Longueur:= Height;
        //ecv2.BinningX:= ;
        //ecv2.BinningY:= ;
        ecv2.SeuilHaut[1]:= Max;
        ecv2.SeuilBas [1]:= Min;
        ecv2.SeuilHaut[2]:= Max;
        ecv2.SeuilBas [2]:= Min;
        ecv2.SeuilHaut[3]:= Max;
        ecv2.SeuilBas [3]:= Min;
        ecv2.TypeData:= 3;
        ecv2.NbrePlan:= 1;
        ecv2.TimeDate:= Now;// should be improved with a date computed in function
                            // of the image index in AVI File
        //ecv2.TempsDePose:= ;
        //ecv2.MiroirX:= ;
        //ecv2.MiroirY:= ;
        //ecv2.Telescope:= 'Meade ETX';
        //ecv2.Observateur:= 'Jean SUZINEAU';
        //ecv2.Camera:= ' camra vido IR';
        //ecv2.Filtre:= '';
        //ecv2.Observatoire:= 'Bridal';
        //ecv2.Focale:= 2500;
        //ecv2.Alpha:= 0;
        //ecv2.Delta:= 0;
        //ecv2.PixX:= 1;
        //ecv2.PixY:= 1;
        ecv2.DebX:= 0;
        ecv2.DebY:= 0;
        ecv2.FinX:= ecv2.Largeur;
        ecv2.FinY:= ecv2.Longueur;
        ecv2.TypeCompression:= 1;
        ecv2.NombreBitsComp:= 8;
        //ecv2.Commentaires[1]:= 'Version Beta';
        //ecv2.Commentaires[2]:= 'Version Beta';
        //ecv2.Commentaires[3]:= 'Version Beta';
        //ecv2.Commentaires[4]:= 'Version Beta';

        BlockWrite( F, ecv2, sizeof(ecv2));

        pbI:= PByteArray( pImage);
        for J:= 0 to Height -1
        do
          begin
          BlockWrite( F, CPAByteWidth, SizeOf(CPAByteWidth));
          BlockWrite( F, pbI^[0], CPAByteWidth);
          pbI:= PByteArray( @(pbI^[CPAByteWidth]));
          end;
        CloseFile( F);
   end;
   procedure ProcessImage;
   begin
        //MessageBeep(0);
        if Stretch_levels then Stretch ;
        if Crop           then Crop_Image;
        Save_CPA;
   end;
begin

     // Pour viter les calculs et drfrencements inutiles
     // (sorry, I don't know the right english expresion for this...)
     Width:= lpbmih^.biWidth;
     CPAByteWidth:= Width*CPAPixelSize;
     Height:= lpbmih^.biHeight;
     ImageSize:= Width * Height*CPAPixelSize;
     _16bits:= lpbmih^.biBitCount = 16;
     if _16bits
     then
         GrayFromBMP:= Gray_From_BMP16
     else
         GrayFromBMP:= Gray_From_BMP24;

     BMPPixelSize:= lpbmih^.biBitCount div 8;

     // Creation of image buffer
     GetMem( pImage, ImageSize);
     FillChar( pImage^, ImageSize, 0);

     //Conversion BMP to CPA
     // and get Min and Max values
     Min:= +32767;
     Max:= -32768;
     pbB:= PByteArray( lpbmih);
     pbB:= PByteArray( @(pbB^[ImageOffset]));

     pbI:= PByteArray( pImage);

     for J:= 0 to Height -1
     do
       for I:= 0 to Width - 1
       do
         begin
         Fish:= GrayFromBMP( pbB);

         psi:= PSmallInt( pbI);
         psi^:= Fish;

         if Min > Fish then Min:= Fish;
         if Max < Fish then Max:= Fish;

         pbB:= PByteArray( @(pbB^[BMPPixelSize]));
         pbI:= PByteArray( @(pbI^[CPAPixelSize]));
         end;

     // Fill ImagesStatistics array
     Inc( LastImage);
     ImagesStatistics[LastImage].Min:= Min;
     ImagesStatistics[LastImage].Max:= Max;


     // Eventually save to a CPA file
     if Save
     then
         if Select_brightest_images
         then
             begin
             if Max = TheMax
             then
                 ProcessImage
             end
         else
             ProcessImage;

     // Destruction of image buffer
     FreeMem( pImage, ImageSize);
end;

procedure GetMinMax;
var
   I: Integer;
   V: SmallInt;
begin
     TheMin:= +32767;
     TheMax:= -32768;
     for I:= 0 to LastImage
     do
       begin
       V:= ImagesStatistics[I].Max;
       if TheMin > V then TheMin:= V;
       if TheMax < V then TheMax:= V;
       end;
end;

initialization
              LastImage:= -1;
              CPANumber:= -1;
finalization
            if CPANumber <> -1 then CloseFile( Log);
end.

