unit ufjsAVI;
{                                                                             |
    Main unit for project jsAVI                                               |
    Graphical interface for library ujsAVI which implements                   |
    a selective extraction of frames from an AVI file to a series of CPA files|
                                                                              |
    Author: Jean SUZINEAU <Jean.Suzineau@wanadoo.fr> http://www.mars42.com    |
                                                                              |
    Copyright (C) 1999  Jean SUZINEAU - MARS42                                |
                                                                              |
    This program is free software; you can redistribute it and/or modify      |
    it under the terms of the GNU General Public License as published by      |
    the Free Software Foundation; either version 2 of the License, or         |
    (at your option) any later version.                                       |
                                                                              |
    This program is distributed in the hope that it will be useful,           |
    but WITHOUT ANY WARRANTY; without even the implied warranty of            |
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
    GNU General Public License for more details.                              |
                                                                              |
    You should have received a copy of the GNU General Public License         |
    along with this program; if not, write to the Free Software               |
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA |
|                                                                             }
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, ExtCtrls, ShellAPI;

type
  TfjsAVI = class(TForm)
    MainMenu1: TMainMenu;
    Fichier1: TMenuItem;
    Ouvrir1: TMenuItem;
    OpenDialog: TOpenDialog;
    Options1: TMenuItem;
    ParamtresfichierCPA1: TMenuItem;
    memoAProposDe: TMemo;
    Aide1: TMenuItem;
    Garantie1: TMenuItem;
    Aproposde1: TMenuItem;
    memoGPL: TMemo;
    LicenceGPLenfranais1: TMenuItem;
    memoGPLFrancais: TMemo;
    Conversion1: TMenuItem;
    procedure Ouvrir1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ParamtresfichierCPA1Click(Sender: TObject);
    procedure Garantie1Click(Sender: TObject);
    procedure Aproposde1Click(Sender: TObject);
    procedure LicenceGPLenfranais1Click(Sender: TObject);
    procedure Conversion1Click(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    procedure HideMemos;
    procedure ProcessFile( FileName: String);
    procedure WndProc(var Message: TMessage); override;
  end;

var
  fjsAVI: TfjsAVI;

implementation

uses
    ujsAVI, uCPA, uRegistry, ufParameters, ufConversion;

{$R *.DFM}

procedure TfjsAVI.ProcessFile( FileName: String);
var
   OldCursor: HCURSOR;
begin
     HideMemos;
     Caption:= 'jsAVI - '+ FileName;
     OldCursor:= SetCursor( LoadCursor( 0, IDC_WAIT));
       ProcessAVIFile( FileName);
     SetCursor( OldCursor);
     DefaultPath:= FileName;
end;

procedure TfjsAVI.Ouvrir1Click(Sender: TObject);
var
   i: Integer;
begin
     OpenDialog.FileName:= DefaultPath;
     if OpenDialog.Execute
     then
         with OpenDialog.Files
         do
           for I:= 0 to Count-1
           do
             ProcessFile( Strings[I]);
end;

procedure TfjsAVI.FormCreate(Sender: TObject);
var
   ModuleName: array[0..257] of char;
   VersionInfoSize, Useless_but_required: DWORD;
   VersionInfo: Pointer;

   Value: Pointer;
   ValueSize: UINT;

   Version: TVSFixedFileInfo;

   sVersion: String;
begin
     // Get version number
     StrPCopy( ModuleName, ParamStr(0));
     VersionInfoSize:= GetFileVersionInfoSize( ModuleName, Useless_but_required);
     GetMem( VersionInfo, VersionInfoSize);
        if GetFileVersionInfo(ModuleName,0,VersionInfoSize, VersionInfo)
        then
            if VerQueryValue( VersionInfo, '\', Value, ValueSize)
            then
                begin
                Move( Value^, Version, ValueSize);
                sVersion
                :=
                  Format( '%d.%d.%d.%d',
                          [
                          HiWord(Version.dwFileVersionMS),
                          LoWord(Version.dwFileVersionMS),
                          HiWord(Version.dwFileVersionLS),
                          LoWord(Version.dwFileVersionLS)
                          ]
                          );
                end
            else
                sVersion:= '< not-available >'
        else
            sVersion:= '< not-available >';
     FreeMem( VersionInfo, VersionInfoSize);

     memoAProposDe.Lines.Strings[1]:= CopyrightNotice;
     memoAProposDe.Lines.Strings[0]
     :=
       Format( 'Programme  jsAVI version %s'#9', Copyright (C) 1999 Jean SUZINEAU',
               [sVersion]);

     From_Registry;
     DragAcceptFiles( Handle, TRUE);
end;

procedure TfjsAVI.WndProc(var Message: TMessage);
var
   hDrop: THandle;
   Iterator: Cardinal;
   FileName: PChar;
   FileNameSize: Cardinal;
   FileCount: Cardinal;
begin
     case Message.Msg
     of
       WM_DROPFILES:
         begin
         hDrop:= Message.wParam;
         FileCount:= DragQueryFile(hDrop,$FFFFFFFF,NIL, 0);

         for Iterator:= 0 to FileCount-1
         do
           begin
           FileNameSize:= DragQueryFile(hDrop,Iterator,NIL, 0)+1;
           FileName:= StrAlloc(FileNameSize);
           DragQueryFile(hDrop,Iterator,FileName, FileNameSize);
           ProcessFile( FileName);
           StrDispose(FileName);
           end;
         DragFinish( hDrop);
         Message.Result:= 0;
         end;
       end;
     inherited WndProc(Message);
end;

procedure TfjsAVI.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     To_Registry;
end;

procedure TfjsAVI.ParamtresfichierCPA1Click(Sender: TObject);
begin
     fParameters.ShowModal;
end;

procedure TfjsAVI.HideMemos;
begin
     memoAProposDe.Hide;
     memoGPL.Hide;
     memoGPLFrancais.Hide;
end;

procedure TfjsAVI.Garantie1Click(Sender: TObject);
begin
     HideMemos;
     memoGPL.Show;
end;

procedure TfjsAVI.Aproposde1Click(Sender: TObject);
begin
     HideMemos;
     memoAProposDe.Show;
end;

procedure TfjsAVI.LicenceGPLenfranais1Click(Sender: TObject);
begin
     HideMemos;
     memoGPLFrancais.Show;
end;

procedure TfjsAVI.Conversion1Click(Sender: TObject);
begin
     fConversion.ShowModal;
end;

end.
  