unit UAVIFILE;
{                                                                             |
    Part of library ujsAVI                                                    |
                                                                              |
    This unit is a quick and dirty import header for avifil32.dll             |
                                                                              |
    Author: Jean SUZINEAU <Jean.Suzineau@wanadoo.fr> http://www.mars42.com    |
                                                                              |
    Copyright (C) 1999  Jean SUZINEAU - MARS42                                |
                                                                              |
    See ujsAVI.pas for full copyright notice.                                 |
|                                                                             }
{
Generated By: HeadConv 3.25 (c) 1998 by Bob Swart (aka Dr.Bob - www.drbob42.com)
          SPECIAL DELPHI-JEDI COMMANDLINE EDITION

Generated Date: 31/05/1999
Generated Time: 17:44:25
}
interface
uses
{$IFDEF WIN32}
  Windows;
{$ELSE}
  Wintypes, WinProcs;
{$ENDIF}


{=> C:\_Projets\CCD\jsAVI_Delphi\UAVIFILE.H <=}

type
    PAVIFILE= pointer;
    PPAVIFILE= ^PAVIFILE;
    PAVISTREAM= pointer;
    PPAVISTREAM= ^PAVISTREAM;
    PAVISTREAMINFOA= pointer;
    PGETFRAME= pointer;
    LPCLSID= pointer;

const
     AVIERR_OK= 0;

{+// }
{-* }
{-* --- AVISTREAMINFO ------------------------------------------------ }
{-* }
{-* for Unicode/Ansi thunking we need to declare three versions of this! }
{= }
type
  _AVISTREAMINFOW = record
    fccType: LongInt;
    fccHandler: LongInt;
    dwFlags: LongInt;
{= Contains AVITF_* flags }
    dwCaps: LongInt;
    wPriority: Word;
    wLanguage: Word;
    dwScale: LongInt;
    dwRate: LongInt;
{= dwRate / dwScale == samples/second }
    dwStart: LongInt;
    dwLength: LongInt;
{= In units above... }
    dwInitialFrames: LongInt;
    dwSuggestedBufferSize: LongInt;
    dwQuality: LongInt;
    dwSampleSize: LongInt;
    rcFrame: TRECT;
    dwEditCount: LongInt;
    dwFormatChangeCount: LongInt;
    szName: Array[0..64-1] of WCHAR;
  end {_AVISTREAMINFOW};
  TAVISTREAMINFOW = _AVISTREAMINFOW;
  LPAVISTREAMINFOW = ^_AVISTREAMINFOW;

type
  _AVISTREAMINFOA = record
    fccType: LongInt;
    fccHandler: LongInt;
    dwFlags: LongInt;
{= Contains AVITF_* flags }
    dwCaps: LongInt;
    wPriority: Word;
    wLanguage: Word;
    dwScale: LongInt;
    dwRate: LongInt;
{= dwRate / dwScale == samples/second }
    dwStart: LongInt;
    dwLength: LongInt;
{= In units above... }
    dwInitialFrames: LongInt;
    dwSuggestedBufferSize: LongInt;
    dwQuality: LongInt;
    dwSampleSize: LongInt;
    rcFrame: TRECT;
    dwEditCount: LongInt;
    dwFormatChangeCount: LongInt;
    szName: Array[0..64-1] of Char;
  end {_AVISTREAMINFOA};
  TAVISTREAMINFOA = _AVISTREAMINFOA;
  LPAVISTREAMINFOA = ^_AVISTREAMINFOA;

{$IFDEF UNICODE}
type
    TAVISTREAMINFO = TAVISTREAMINFOW;
    LPAVISTREAMINFO = LPAVISTREAMINFOW;
{$ELSE}
type
    TAVISTREAMINFO = TAVISTREAMINFOA;
    LPAVISTREAMINFO = LPAVISTREAMINFOA;
{$ENDIF}


{+// }
{-** Stream types for the <fccType> field of the stream header. }
{= }
// dfinitions bricoles
var
   _streamtypeVIDEO: array[1..4] of char= 'vids';
   streamtypeVIDEO: LongInt absolute _streamtypeVIDEO;
var
   _streamtypeAUDIO: array[1..4] of char= 'auds';
   streamtypeAUDIO:LongInt absolute _streamtypeAUDIO;
var
   _streamtypeMIDI: array[1..4] of char= 'mids';
   streamtypeMIDI:LongInt absolute _streamtypeMIDI;
var
   _streamtypeTEXT: array[1..4] of char= 'txts';
   streamtypeTEXT:LongInt absolute _streamtypeTEXT;


var
  AVIStreamInfoA: function( pavi: PAVISTREAM;
                             psi: PAVISTREAMINFOA;
                           lSize: LongInt): HRESULT cdecl  {$IFDEF WIN32} stdcall {$ENDIF};
  AVIStreamInfo: function( pavi: PAVISTREAM;
                             psi: PAVISTREAMINFOA;
                           lSize: LongInt): HRESULT cdecl  {$IFDEF WIN32} stdcall {$ENDIF};
var
  AVIStreamGetFrameOpen: function( pavi: PAVISTREAM;
                                   lpbiWanted: PBitmapInfoHeader): PGETFRAME cdecl  {$IFDEF WIN32} stdcall {$ENDIF};
var
  AVIStreamGetFrame: function( pg: PGETFRAME;
                              lPos: LongInt): pointer cdecl  {$IFDEF WIN32} stdcall {$ENDIF};
var
  AVIStreamGetFrameClose: function( pg: PGETFRAME): HRESULT cdecl  {$IFDEF WIN32} stdcall {$ENDIF};
var
  AVIFileRelease: function( pfile: PAVIFILE): ULONG cdecl  {$IFDEF WIN32} stdcall {$ENDIF};
var
  AVIFileOpenA: function(ppfile: PPAVIFILE;
                         szFile: PChar;
                         uMode: Word;
                         lpHandler: LPCLSID): HRESULT cdecl  {$IFDEF WIN32} stdcall {$ENDIF};
  AVIFileOpen: function( ppfile: PPAVIFILE;
                         szFile: PChar;
                         uMode: Word;
                         lpHandler: LPCLSID): HRESULT cdecl  {$IFDEF WIN32} stdcall {$ENDIF};
var
  AVIFileGetStream: function( pfile: PAVIFILE;
                             ppavi: PPAVISTREAM;
                             fccType: LongInt;
                             lParam: LongInt): HRESULT cdecl  {$IFDEF WIN32} stdcall {$ENDIF};
var
  AVIFileInit: procedure cdecl  {$IFDEF WIN32} stdcall {$ENDIF};
var
  AVIFileExit: procedure cdecl  {$IFDEF WIN32} stdcall {$ENDIF};

var
  AVIStreamReadFormat: function( pavi: PAVISTREAM;
                                lPos: LongInt;
                                lpFormat: Pointer;
                                var lpcbFormat: LongInt): HRESULT cdecl  {$IFDEF WIN32} stdcall {$ENDIF};
var
  DLLLoaded: Boolean { is DLL (dynamically) loaded already? }
    {$IFDEF WIN32} = False; {$ENDIF}

implementation

var
  SaveExit: pointer;
  DLLHandle: THandle;
{$IFNDEF MSDOS}
  ErrorMode: Integer;
{$ENDIF}

  procedure NewExit; far;
  begin
    ExitProc := SaveExit;
    FreeLibrary(DLLHandle)
  end {NewExit};

procedure LoadDLL;
begin
  if DLLLoaded then Exit;
{$IFNDEF MSDOS}
  ErrorMode := SetErrorMode($8000{SEM_NoOpenFileErrorBox});
{$ENDIF}
  DLLHandle := LoadLibrary('avifil32.dll');
  if DLLHandle >= 32 then
  begin
    DLLLoaded := True;
    SaveExit := ExitProc;
    ExitProc := @NewExit;
    @AVIStreamInfoA := GetProcAddress(DLLHandle,'AVIStreamInfoA');
  {$IFDEF WIN32}
    Assert(@AVIStreamInfoA <> nil);
  {$ENDIF}
    @AVIStreamInfo:= @AVIStreamInfoA;
    @AVIStreamGetFrameOpen := GetProcAddress(DLLHandle,'AVIStreamGetFrameOpen');
  {$IFDEF WIN32}
    Assert(@AVIStreamGetFrameOpen <> nil);
  {$ENDIF}
    @AVIStreamGetFrame := GetProcAddress(DLLHandle,'AVIStreamGetFrame');
  {$IFDEF WIN32}
    Assert(@AVIStreamGetFrame <> nil);
  {$ENDIF}
    @AVIStreamGetFrameClose := GetProcAddress(DLLHandle,'AVIStreamGetFrameClose');
  {$IFDEF WIN32}
    Assert(@AVIStreamGetFrameClose <> nil);
  {$ENDIF}
    @AVIFileRelease := GetProcAddress(DLLHandle,'AVIFileRelease');
  {$IFDEF WIN32}
    Assert(@AVIFileRelease <> nil);
  {$ENDIF}
    @AVIFileOpenA := GetProcAddress(DLLHandle,'AVIFileOpenA');
  {$IFDEF WIN32}
    Assert(@AVIFileOpenA <> nil);
  {$ENDIF}
    @AVIFileOpen:= @AVIFileOpenA;
    @AVIFileGetStream := GetProcAddress(DLLHandle,'AVIFileGetStream');
  {$IFDEF WIN32}
    Assert(@AVIFileGetStream <> nil);
  {$ENDIF}
    @AVIFileInit := GetProcAddress(DLLHandle,'AVIFileInit');
  {$IFDEF WIN32}
    Assert(@AVIFileInit <> nil);
  {$ENDIF}
    @AVIFileExit := GetProcAddress(DLLHandle,'AVIFileExit');
  {$IFDEF WIN32}
    Assert(@AVIFileExit <> nil);
  {$ENDIF}
    @AVIStreamReadFormat := GetProcAddress(DLLHandle,'AVIStreamReadFormat');
  {$IFDEF WIN32}
    Assert(@AVIStreamReadFormat <> nil);
  {$ENDIF}
  end
  else
  begin
    DLLLoaded := False;
    { Error: UAVIFILE.DLL could not be loaded !! }
  end;
{$IFNDEF MSDOS}
  SetErrorMode(ErrorMode)
{$ENDIF}
end {LoadDLL};

begin
  LoadDLL;
end.
