unit uRegistry;
{                                                                             |
    Part of library ujsAVI                                                    |
                                                                              |
    Helper unit for saving and restoring "DefaultHeader" variable of unit uCPA|
                                                                              |
    Author: Jean SUZINEAU <Jean.Suzineau@wanadoo.fr> http://www.mars42.com    |
                                                                              |
    Copyright (C) 1999  Jean SUZINEAU - MARS42                                |
                                                                              |
    See ujsAVI.pas for full copyright notice.                                 |
|                                                                             }
interface

uses
    SysUtils,
    Registry,
    uCPA;

const
     reg_AppRootKey: String= '\Software\jsAVI';

var
   DefaultPath: String;

procedure From_Registry;

procedure To_Registry;

implementation

procedure From_Registry;
var
   R: TRegINIFile;
   function R_ReadFloat( Section, Key, _Default: String): double;
   var
      S: String;
   begin
        S:= R.ReadString( Section, Key, _Default);
        Result:= StrToFloat( S);
   end;
begin
     R:= TRegINIFile.Create( reg_AppRootKey);
     try
        //DefaultHeader.Signature    := $F5C7D1FA;          // overloaded in uCPA
        //DefaultHeader.Largeur      := Largeur;            // overloaded in uCPA
        //DefaultHeader.Longueur     := Longueur;           // overloaded in uCPA
        DefaultHeader.BinningX       := R.ReadInteger( 'DefaultHeader', 'BinningX'    , 1);
        DefaultHeader.BinningY       := R.ReadInteger( 'DefaultHeader', 'BinningY'    , 1);
        //DefaultHeader.SeuilHaut[1] := Max;                // overloaded in uCPA
        //DefaultHeader.SeuilBas [1] := Min;                // overloaded in uCPA
        //DefaultHeader.SeuilHaut[2] := Max;                // overloaded in uCPA
        //DefaultHeader.SeuilBas [2] := Min;                // overloaded in uCPA
        //DefaultHeader.SeuilHaut[3] := Max;                // overloaded in uCPA
        //DefaultHeader.SeuilBas [3] := Min;                // overloaded in uCPA
        //DefaultHeader.TypeData     := 3;                  // overloaded in uCPA
        //DefaultHeader.NbrePlan     := 1;                  // overloaded in uCPA
        //DefaultHeader.TimeDate     := Now;                // overloaded in uCPA
        DefaultHeader.TempsDePose    := R_ReadFloat ( 'DefaultHeader', 'TempsDePose' , '0');
        DefaultHeader.MiroirX        := R.ReadBool  ( 'DefaultHeader', 'MiroirX'     , False);
        DefaultHeader.MiroirY        := R.ReadBool  ( 'DefaultHeader', 'MiroirY'     , False);
        DefaultHeader.Telescope      := R.ReadString( 'DefaultHeader', 'Telescope'   , '');
        DefaultHeader.Observateur    := R.ReadString( 'DefaultHeader', 'Observateur' , '');
        DefaultHeader.Camera         := R.ReadString( 'DefaultHeader', 'Camera'      , '');
        DefaultHeader.Filtre         := R.ReadString( 'DefaultHeader', 'Filtre'      , '');
        DefaultHeader.Observatoire   := R.ReadString( 'DefaultHeader', 'Observatoire', '');
        DefaultHeader.Focale         := R_ReadFloat ( 'DefaultHeader', 'Focale'      , '0');
        DefaultHeader.Alpha          := R_ReadFloat ( 'DefaultHeader', 'Alpha'       , '0');
        DefaultHeader.Delta          := R_ReadFloat ( 'DefaultHeader', 'Delta'       , '0');
        DefaultHeader.PixX           := R_ReadFloat ( 'DefaultHeader', 'PixX'        , '0');
        DefaultHeader.PixY           := R_ReadFloat ( 'DefaultHeader', 'PixY'        , '0');
        //DefaultHeader.DebX         := 0;                  // overloaded in uCPA
        //DefaultHeader.DebY         := 0;                  // overloaded in uCPA
        //DefaultHeader.FinX         := DefaultHeader.Largeur;// overloaded in uCPA
        //DefaultHeader.FinY         := DefaultHeader.Longueur;// overloaded in uCPA
        //DefaultHeader.TypeCompression:= 1;                // overloaded in uCPA
        //DefaultHeader.NombreBitsComp:= 8;                 // overloaded in uCPA
        DefaultHeader.Commentaires[1]:= R.ReadString( 'DefaultHeader', 'Commentaires1', '');
        DefaultHeader.Commentaires[2]:= R.ReadString( 'DefaultHeader', 'Commentaires2', '');
        DefaultHeader.Commentaires[3]:= R.ReadString( 'DefaultHeader', 'Commentaires3', '');
        DefaultHeader.Commentaires[4]:= R.ReadString( 'DefaultHeader', 'Commentaires4', '');

        Select_brightest_images
        :=
          R.ReadBool   ( 'Conversion', 'Select_brightest_images', False);

        Stretch_levels:= R.ReadBool   ( 'Conversion', 'Stretch_levels', False);
        Crop          := R.ReadBool   ( 'Conversion', 'Crop'          , False);
        Crop_Width    := R.ReadInteger( 'Conversion', 'Crop_Width'    ,   400);

        DefaultPath:= R.ReadString( 'Files', 'DefaultPath', '');
     finally
            R.Free;
            end;
end;

procedure To_Registry;
var
   R: TRegINIFile;
   procedure R_WriteFloat( Section, Key: String; Value: Extended);
   var
      S: String;
   begin
        S:= FloatToStr( Value);

        R.WriteString( Section, Key, S);
   end;
begin
     R:= TRegINIFile.Create( reg_AppRootKey);
     try
        //DefaultHeader.Signature    := $F5C7D1FA;          // overloaded in uCPA
        //DefaultHeader.Largeur      := Largeur;            // overloaded in uCPA
        //DefaultHeader.Longueur     := Longueur;           // overloaded in uCPA
        R.WriteInteger( 'DefaultHeader', 'BinningX', DefaultHeader.BinningX);
        R.WriteInteger( 'DefaultHeader', 'BinningY', DefaultHeader.BinningY);
        //DefaultHeader.SeuilHaut[1] := Max;                // overloaded in uCPA
        //DefaultHeader.SeuilBas [1] := Min;                // overloaded in uCPA
        //DefaultHeader.SeuilHaut[2] := Max;                // overloaded in uCPA
        //DefaultHeader.SeuilBas [2] := Min;                // overloaded in uCPA
        //DefaultHeader.SeuilHaut[3] := Max;                // overloaded in uCPA
        //DefaultHeader.SeuilBas [3] := Min;                // overloaded in uCPA
        //DefaultHeader.TypeData     := 3;                  // overloaded in uCPA
        //DefaultHeader.NbrePlan     := 1;                  // overloaded in uCPA
        //DefaultHeader.TimeDate     := Now;                // overloaded in uCPA
        R_WriteFloat ( 'DefaultHeader', 'TempsDePose' , DefaultHeader.TempsDePose    );
        R.WriteBool  ( 'DefaultHeader', 'MiroirX'     , DefaultHeader.MiroirX        );
        R.WriteBool  ( 'DefaultHeader', 'MiroirY'     , DefaultHeader.MiroirY        );
        R.WriteString( 'DefaultHeader', 'Telescope'   , DefaultHeader.Telescope      );
        R.WriteString( 'DefaultHeader', 'Observateur' , DefaultHeader.Observateur    );
        R.WriteString( 'DefaultHeader', 'Camera'      , DefaultHeader.Camera         );
        R.WriteString( 'DefaultHeader', 'Filtre'      , DefaultHeader.Filtre         );
        R.WriteString( 'DefaultHeader', 'Observatoire', DefaultHeader.Observatoire   );
        R_WriteFloat ( 'DefaultHeader', 'Focale'      , DefaultHeader.Focale         );
        R_WriteFloat ( 'DefaultHeader', 'Alpha'       , DefaultHeader.Alpha          );
        R_WriteFloat ( 'DefaultHeader', 'Delta'       , DefaultHeader.Delta          );
        R_WriteFloat ( 'DefaultHeader', 'PixX'        , DefaultHeader.PixX           );
        R_WriteFloat ( 'DefaultHeader', 'PixY'        , DefaultHeader.PixY           );
        //DefaultHeader.DebX         := 0;                  // overloaded in uCPA
        //DefaultHeader.DebY         := 0;                  // overloaded in uCPA
        //DefaultHeader.FinX         := DefaultHeader.Largeur;// overloaded in uCPA
        //DefaultHeader.FinY         := DefaultHeader.Longueur;// overloaded in uCPA
        //DefaultHeader.TypeCompression:= 1;                // overloaded in uCPA
        //DefaultHeader.NombreBitsComp:= 8;                 // overloaded in uCPA
        R.WriteString( 'DefaultHeader', 'Commentaires1', DefaultHeader.Commentaires[1]);
        R.WriteString( 'DefaultHeader', 'Commentaires2', DefaultHeader.Commentaires[2]);
        R.WriteString( 'DefaultHeader', 'Commentaires3', DefaultHeader.Commentaires[3]);
        R.WriteString( 'DefaultHeader', 'Commentaires4', DefaultHeader.Commentaires[4]);

        R.WriteBool   ( 'Conversion', 'Select_brightest_images',Select_brightest_images);
        R.WriteBool   ( 'Conversion', 'Stretch_levels'         , Stretch_levels        );
        R.WriteBool   ( 'Conversion', 'Crop'                   , Crop                  );
        R.WriteInteger( 'Conversion', 'Crop_Width'             , Crop_Width            );

        R.WriteString( 'Files', 'DefaultPath', DefaultPath);
     finally
            R.Free;
            end;
end;

end.
